pro ch2xsm_read_drm,DRM_STR ; , FILE=file ;, SFILE=sfile, ERR_CODE=err_code, ERR_MSG=err_msg

;; This program reads Chandrayaan-2 Solar X-ray Monitor (XSM) response matrix 
;; for OSPEX. Called by ch2xsm_read_data when invoked from OSPEX.
;; 
;; Based on OSPEX doc to read 'any' data file - https://hesperia.gsfc.nasa.gov/ssw/packages/spex/doc/ospex_any_specfile.htm
;;      
;; Mithun N P S (18/08/20)
;;
;; Test revision 10/02/22 
;;      - modified the drm units to make it counts/kev per photon as expected by OSPEX 
;;      - geometric area taken out from drm and included in area variable
;; 
;; Updates to include response with Be filter

    err_code = 0
    err_msg = ''

    respfilename_open='$xsmdas/caldb/CH2xsmrspwitharea_open20191214v01.rsp'
    respfilename_beft='$xsmdas/caldb/CH2xsmrspwitharea_beft20191214v01.rsp'

	d1=mrdfits(respfilename_open,1,/unsigned,/dscale)
	d2=mrdfits(respfilename_open,2,/unsigned,/dscale)

    d2_beft=mrdfits(respfilename_beft,2,/unsigned,/dscale)

	
	edges_out=transpose([[d1.E_MIN],[d1.E_MAX]])
	edges_in=transpose([[d2.ENERG_LO],[d2.ENERG_HI]])

	area=0.00364999
	drm1=d2.matrix
	sepdets=0
	data_name='CH-2 XSM'
	atten_state=[0,2]
	detused='XSM SDD'

	;; Select above 1 keV only

	ind_out=where(edges_out(0,*) ge 1.0 and edges_out(0,*) lt 15.0)
	ind_in=where(edges_in(0,*) ge 1.0)

    edges_out=edges_out(*,ind_out)
    edges_in=edges_in(*,ind_in)

    drm1=d2.matrix
	drm1=drm1[*,ind_in]
	drm1=drm1[ind_out,*]

    drm2=d2_beft.matrix
    drm2=drm2[*,ind_in]
    drm2=drm2[ind_out,*]

    ;; Convert drm to units of counts/keV per photon by dividing with instrument channel widths
    ;; Also divide by geometric area as the geometric area is now set to the area variable.
	drm1=drm1/(0.033*0.00364999) 
    drm2=drm2/(0.033*0.00364999)
    
    sz=size(drm1)
    drm=make_array([sz[1],sz[2],2])
    drm(*,*,0)=drm1
    drm(*,*,1)=drm2

	;; Trying different filter state eff area for time dependance
	;drm_filt=fltarr(n_elements(ind_out),n_elements(ind_in),20)
	;atten_state=findgen(20)
	;for i=0,19 do drm_filt(*,*,i)=drm
	;drm=drm_filt

	drm_str = { $
	EDGES_OUT: edges_out, $ ;[2,nedges_out] count energy edges in keV
	;PH_EDGES: ph_edges, $ ;[2,nedges_in] photon energy edges in keV
	EDGES_IN: edges_in, $ ;[2,nedges_in] photon energy edges in keV
    AREA: area, $ ;detector area in cm^2
	DRM: drm, $ ;[nedges_out,nedges_in,nfilter] DRM matrix for each filter state
	SEPDETS: sepdets, $ ;1 if separate detectors
	DATA_NAME: data_name, $ ;string name of data, e.g. 'RHESSI'
	FILTER: atten_state, $ ;[nfilter] value of filter states, or scalar -1 if doesn't apply
	DETUSED: detused } ;string of detectors used, e.g. '1F 3F 4F 5F 6F 8F 9F'

end
